<?php
/*
Plugin Name: LoftOcean Instagram
Plugin URI: http://www.loftocean.com/
Description: Bridge plugin for resolving Instagram issue.
Version: 1.2.0
Author: Loft.Ocean
Author URI: http://www.loftocean.com/
Text Domain: loftocean-instagram
License: GPLv2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/


/**
 * LoftLoader main file
 *
 * @package   LoftLoader
 * @link	  http://www.loftocean.com/
 * @author	  Suihai Huang from Loft Ocean Team
 */

// Not allowed by directly accessing.
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'LOFTOCEAN_INSTAGRAM_INC', dirname( __FILE__ ) . '/includes/' );

/**
* Load plugin text domain
*/
add_action( 'plugins_loaded', 'loftocean_instagram_load_textdomain' );
function loftocean_instagram_load_textdomain() {
	load_plugin_textdomain( 'loftocean-instagram' );
}

/**
* Init LoftOcean Instagram
*/
add_action( 'after_setup_theme', 'loftocean_instagram_init', 99999 );
function loftocean_instagram_init() {
	if ( function_exists( 'sbi_get_database_settings' ) ) {
		require_once LOFTOCEAN_INSTAGRAM_INC . 'class-customizer.php';
		require_once LOFTOCEAN_INSTAGRAM_INC . 'class-feed.php';
	}
}
/**
* Get current theme name
*/
function loftocean_instagram_get_current_theme() {
	$theme = wp_get_theme();
	$template = $theme->get( 'Template' );
	$folder = empty( $template ) ? $theme->get( 'Name' ) : $template;
	return strtolower( $folder );
}
/**
* Get instagram feeds
*/
function loftocean_instagram_get_instagram_feeds() {
	if ( method_exists( SB_Instagram_Feed::class, 'set_cache' ) ) {
		global $wpdb;
		$feeds_table_name = $wpdb->prefix . 'sbi_feeds';
		$feeds_list = $wpdb->get_results( "SELECT id, feed_name FROM $feeds_table_name;" );

		if ( ! empty( $feeds_list ) ) {
			$sbi_statuses = get_option( 'sbi_statuses', array() );
			$feeds_elementor  = array( '' => ( empty( $sbi_statuses[ 'support_legacy_shortcode' ] ) ? esc_html__( 'Select a Feed', 'loftocean' ) : esc_html__( 'Default', 'loftocean' ) ) );
			foreach ( $feeds_list as $feed ) {
				$feeds_elementor[ $feed->id ] = $feed->feed_name;
			}
			return $feeds_elementor;
		}
	}
	return false;
}
