<?php
namespace LoftOceanInstagram;

if ( ! class_exists( 'Feeds' ) ) {
    class Feeds {
        /**
        * Construct function
        */
        public function __construct() {
            if ( $this->is_token_enabled() ) {
                add_filter( 'berry_instagram_get_feed', array( $this, 'get_feeds' ), 999, 2 );
                add_filter( 'loftocean_instagram_feed', array( $this, 'get_feeds' ), 999, 3 );
                add_filter( 'loftocean_instagram_get_feed', array( $this, 'get_feeds' ), 999, 3 );
				
				add_action( 'wp_loaded', array( $this, 'remove_filters' ) );
            }
        }
        /**
		* @description get instagram feed from transient or from instagram site
		* @param string username
		* @param int number of feeds to get
		* @return mix if feeds exists, return array of feeds otherwise return boolean false
		*/
		public function get_feeds( $instagram, $username = '', $limit = 24 ) {
			return $this->get_feeds_by_token( $limit );
		}
		/**
		* Get feeds by token
		*/
		protected function get_feeds_by_token( $limit = 24 ) {
			if ( function_exists( '\sbi_get_database_settings' ) ) {
				$atts = array( 'num' => $limit, 'feed' => get_option( 'loftocean_instagram_token_feed', 'legacy' ) );
                $new_plugin = method_exists( \SB_Instagram_Feed::class, 'set_cache' );
				$database_settings = \sbi_get_database_settings();
				if ( ! $new_plugin && empty( $database_settings['connected_accounts'] ) ) {
					return false;
				}

				$instagram_feed_settings = new \SB_Instagram_Settings( $atts, $database_settings, false );
				$instagram_feed_settings->set_feed_type_and_terms();
				$instagram_feed_settings->set_transient_name();
				$transient_name = $instagram_feed_settings->get_transient_name();
				$settings = $instagram_feed_settings->get_settings();
				$feed_type_and_terms = $instagram_feed_settings->get_feed_type_and_terms();
				$instagram_feed = new \SB_Instagram_Feed( $transient_name );

				if ( $new_plugin ) {
					$instagram_feed->set_cache( $instagram_feed_settings->get_cache_time_in_seconds(), $settings );
				}

				if ( $database_settings['sbi_caching_type'] === 'background' ) {
				    $instagram_feed->add_report( 'background caching used' );
				    if ( $instagram_feed->regular_cache_exists() ) {
				        $instagram_feed->add_report( 'setting posts from cache' );
				        $instagram_feed->set_post_data_from_cache();
				    }

				    if ( $instagram_feed->need_to_start_cron_job() ) {
				        $instagram_feed->add_report( 'setting up feed for cron cache' );
				        $to_cache = array(
				            'atts' => $atts,
				            'last_requested' => time(),
				        );

				        $instagram_feed->set_cron_cache( $to_cache, $instagram_feed_settings->get_cache_time_in_seconds() );

				        \SB_Instagram_Cron_Updater::do_single_feed_cron_update( $instagram_feed_settings, $to_cache, $atts, false );

				        $instagram_feed->set_post_data_from_cache();

				    } elseif ( $instagram_feed->should_update_last_requested() ) {
				        $instagram_feed->add_report( 'updating last requested' );
				        $to_cache = array(
				            'last_requested' => time(),
				        );

				        $instagram_feed->set_cron_cache( $to_cache, $instagram_feed_settings->get_cache_time_in_seconds(), $settings['backup_cache_enabled'] );
				    }

				} else if ( $instagram_feed->regular_cache_exists() ) {
				    $instagram_feed->add_report( 'page load caching used and regular cache exists' );
				    $instagram_feed->set_post_data_from_cache();

				    if ( $instagram_feed->need_posts( $settings['num'] ) && $instagram_feed->can_get_more_posts() ) {
				        while ( $instagram_feed->need_posts( $settings['num'] ) && $instagram_feed->can_get_more_posts() ) {
				            $instagram_feed->add_remote_posts( $settings, $feed_type_and_terms, $instagram_feed_settings->get_connected_accounts_in_feed() );
				        }
				        $instagram_feed->cache_feed_data( $instagram_feed_settings->get_cache_time_in_seconds(), $settings['backup_cache_enabled'] );
				    }

				} else {
				    $instagram_feed->add_report( 'no feed cache found' );

				    while ( $instagram_feed->need_posts( $settings['num'] ) && $instagram_feed->can_get_more_posts() ) {
				        $instagram_feed->add_remote_posts( $settings, $feed_type_and_terms, $instagram_feed_settings->get_connected_accounts_in_feed() );
				    }

				    if ( ! $instagram_feed->should_use_backup() ) {
				        $instagram_feed->cache_feed_data( $instagram_feed_settings->get_cache_time_in_seconds(), $settings['backup_cache_enabled'] );
				    }

				}

				if ( $instagram_feed->should_use_backup() ) {
				    $instagram_feed->add_report( 'trying to use backup' );
				    $instagram_feed->maybe_set_post_data_from_backup();
				    $instagram_feed->maybe_set_header_data_from_backup();
				}

				if ( $settings['resizeprocess'] === 'page' ) {
				    $instagram_feed->add_report( 'resizing images for post set' );
				    $post_data = $instagram_feed->get_post_data();
				    $post_data = array_slice( $post_data, 0, $settings['num'] );
				} else {
					$post_data = $instagram_feed->get_post_data();
				    $post_data = array_slice( $post_data, 0, $settings['num'] );
				}
				$feeds = array();
				if ( is_array( $post_data ) ) {
					foreach ( $post_data as $data ) {
						$type = $this->get_type( $data['media_url'] );
                        $media_url = empty( $data['thumbnail_url'] ) ? $data['media_url'] : $data['thumbnail_url'];
						array_push( $feeds, array(
							'description'   => empty( $data['caption'] ) ? esc_attr__( 'Instagram Image', 'loftocean') : $data['caption'],
							'link'		  	=> esc_url_raw( $data['permalink'] ),
							'thumbnail'	 	=> $media_url,
							'small'			=> $media_url,
							'large'			=> $media_url,
							'original'		=> $media_url,
							'type'		  	=> $type
						) );
					}
				}
				return $feeds;
			}
			return false;
		}
		/**
		* Get instagram post type
		*/
		protected function get_type( $url ) {
			if ( ! empty( $url ) ) {
				if ( preg_match( '/\.(mp4|mov)($|\?)/i', $url ) ) {
					return 'video';
				} else if ( preg_match( '/\.(jpeg|jpg|png|bmp|gif)($|\?)/i', $url ) ) {
					return 'image';
				}
			}
			return false;
		}
        /**
        * Test if using instagram new token
        */
        protected function is_token_enabled() {
            return ( 'on' != get_option( 'loftocean_instagram_token_enabled', '' ) ) && ( 'on' == get_option( 'loftocean_instagram_enable_token', '' ) );
        }
		public function remove_filters( ) {
			if ( function_exists( 'berry_extension_get_instagram_feed' ) ) {
				remove_filter( 'berry_instagram_get_feed', 'berry_extension_get_instagram_feed', 10, 2 );
			}
			
			remove_all_filters( 'loftocean_instagram_feed' );
			add_filter( 'loftocean_instagram_feed', array( $this, 'get_feeds' ), 999, 3 );
			
			remove_all_filters( 'loftocean_instagram_get_feed' );
			add_filter( 'loftocean_instagram_get_feed', array( $this, 'get_feeds' ), 999, 3 );
		}
    }
    new Feeds();
}
