<?php
namespace LoftOceanInstagram;

if ( ! class_exists( 'Customizer' ) ) {
    class Customizer {
        /**
        * Current theme name
        */
        protected $current_theme = false;
        /**
        * Construct function
        */
        public function __construct() {
            $this->current_theme = loftocean_instagram_get_current_theme();
    		add_action( 'customize_register', array( $this, 'register_customize_settings' ), 99999 );
        }
        /**
        * Register customize settings
        */
        public function register_customize_settings( $wp_customize ) {
            if ( $this->plugin_required( $wp_customize ) && ! $wp_customize->get_setting( 'loftocean_instagram_token_enabled' ) ) {
                require_once LOFTOCEAN_INSTAGRAM_INC . 'class-customize-control.php';
                $wp_customize->add_setting( new \WP_Customize_Setting( $wp_customize, 'loftocean_instagram_enable_token', array(
    				'default'			=> '',
    				'transport'			=> 'refresh',
    				'type' 				=> 'option',
    				'sanitize_callback' => array( $this, 'sanitize_checkbox' )
    			) ) );
				$wp_customize->add_setting( new \WP_Customize_Setting( $wp_customize, 'loftocean_instagram_token_feed', array(
					'default'			=> '',
					'transport'			=> 'refresh',
					'type' 				=> 'option',
					'sanitize_callback' => 'sanitize_text_field'
				) ) );

    			$wp_customize->add_control( new Customize_Control( $wp_customize, 'loftocean_instagram_enable_token', array(
    				'type' 			=> 'checkbox',
    				'label_first'	=> true,
    				'label'			=> esc_html__( 'Using Instagram Token (optional)', 'loftocean' ),
    				'section'		=> $this->get_customize_section_id(),
    				'settings' 		=> 'loftocean_instagram_enable_token',
    			) ) );
				$feeds = loftocean_instagram_get_instagram_feeds();
				if ( is_array( $feeds ) && ( count( $feeds ) > 0 ) ) {
					$wp_customize->add_control( new Customize_Control( $wp_customize, 'loftocean_instagram_token_feed', array(
						'type' 				=> 'select',
						'label'				=> esc_html__( 'Select a Feed', 'loftocean' ),
						'section'			=> $this->get_customize_section_id(),
						'settings' 			=> 'loftocean_instagram_token_feed',
						'choices'			=> $feeds,
						'active_callback'	=> array( $this, 'customize_control_active_cb' )
					) ) );
				}
                // Remove control not needed
                $token_control_id = $this->get_token_control_id();
                $token_control = $wp_customize->get_control( $token_control_id );
                if ( $token_control ) {
                    $wp_customize->remove_control( $token_control_id );
                }
            }
        }
        /**
        * Conditional function
        */
        protected function plugin_required( $wp_customize ) {
            if ( in_array( $this->current_theme, array( 'berry', 'ceramag', 'fallsky', 'eaven' ) ) ) {
                $control = $wp_customize->get_control( 'loftocean_instagram_token_enabled' );
                return empty( $control );
            }
            return false;
        }
        /**
        * Get customize section id
        */
        protected function get_customize_section_id() {
            switch ( $this->current_theme ) {
                case 'berry':
                    return 'berry_instagram';
                case 'ceramag':
                    return 'ceramag_section_instagram';
                case 'fallsky':
                    return 'fallsky_section_general_instagram';
                default:
                    return 'loftocean_section_instagram';
            }
        }
        /**
        * Get control token id
        */
        protected function get_token_control_id() {
            switch ( $this->current_theme ) {
                case 'ceramag':
                    return 'ceramag_instagram_token';
                case 'fallsky':
                    $token = get_option( 'fallsky_instagram_token', '' );
                    empty( $token ) ? update_option( 'fallsky_instagram_token', 'test' ) : '';
                    return 'fallsky_instagram_token';
                default:
                    return 'loftocean_instagram_token';
            }
        }
        /**
        * Sanitize value from checkbox
        * @param mix
        * @return string
        */
        public function sanitize_checkbox( $value ) {
        	return empty( $value ) ? '' : 'on';
        }
		public function customize_control_active_cb() {
			return 'on' == get_option( 'loftocean_instagram_enable_token', '' );
		}
    }
    new Customizer();
}
